
#include <LiquidCrystal.h>

LiquidCrystal lcd(12, 11, 8, 7, 3, 2);

int latchPin = 5;
int clockPin = 6;
int dataPin = 4;
int alarm = 9;
int tusdirenc = A1;

int basla = 1;
int sec = 0;

int prbasla = 0;
int dmenu = 0;
byte silme = 0;

byte regdata; 

int tusf = 0;
int tusr = 0;
int sutun = 0;
String adim = "";
String fdirenc = "";

int msb = 0;
int lsb = 1;
int s_sayac = 0;  

byte dataArraylsb[] = {
    B00000000, B00000001, B00000010, B00000011, B00000100, B00000101, B00000110, B00000111, B00001000, B00001001, B00001010, B00001011, B00001100, B00001101, B00001110, B00001111
  };

byte dataArraymsb[] = {
    B00000000, B00010000, B00100000, B00110000, B01000000, B01010000, B01100000, B01110000, B10000000, B10010000, B10100000, B10110000, B11000000, B11010000, B11100000, B11110000
  };
byte sifirla[] = {
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

void setup()
{
  lcd.begin(16, 2);

 lcd.setCursor(0,0);
 lcd.print("TUS TAKIMI TEST");
 lcd.setCursor(6,1);
 lcd.print("v1.0");
 delay(500);
 
  pinMode(latchPin, OUTPUT);
  pinMode(dataPin, OUTPUT);  
  pinMode(clockPin, OUTPUT);
  pinMode(alarm, OUTPUT);
  pinMode(basla, INPUT);
  pinMode(sec, INPUT);

}
 
void loop() {

if (digitalRead(basla) == HIGH || prbasla == 1 ) {  
prbasla = 1;

if (digitalRead(sec) == HIGH && silme == 0) { //Silme aktif

silme = 1;
msb = 0;
lsb = 1;
s_sayac = 0;
tusf = 0;
tusr = 0;
adim = "";
fdirenc = "";

lcd.clear();
lcd.setCursor(0,0);
lcd.print("Siliniyor..");
}


regdata = dataArraymsb[lsb] | dataArraylsb[msb] ;
registeryaz();

tusr = analogRead(tusdirenc);

delay(2); 

regdata = dataArraymsb[msb] | dataArraylsb[lsb] ;
registeryaz();

tusf = analogRead(tusdirenc);


if ((tusf >= 3 || tusr >= 3) && (dmenu == 1 && sifirla[s_sayac] != 1 )) { // Kademeli Modunda
if (silme == 1 ) {
sifirla[s_sayac] = 1; 
} else {
ekranyaz();
}
}

if (dmenu == 3 && tusf >= 3 && tusr >= 3 && sifirla[s_sayac] != 1) { // Diyotsuz Modunda
if (silme == 1 ) {
sifirla[s_sayac] = 1; 
} else {
ekranyaz();
}
}

s_sayac++;
 
lsb = lsb + 1 ;

if (lsb > 15 ) {
msb = msb + 1;
lsb = msb + 1;
}

if (msb > 14) { //Test başa döndüğünde
msb = 0;
lsb = 1;
s_sayac = 0;
silme = 0;

lcd.clear();
lcd.setCursor(0,0);
lcd.print("Test ediliyor..");

}

delay(2); 

} else {

menu();

}

}


void registeryaz() {
   digitalWrite(latchPin, LOW);
   shiftOut(dataPin, clockPin, LSBFIRST, regdata);
   digitalWrite(latchPin, HIGH);
}


void ekranyaz() {

  
 adim = String(msb+1) + " " + String(lsb+1);
 
 if (tusf >= 3) {
 fdirenc = "> 100k";
 }
 if (tusf >= 8) {
 fdirenc = "< 100k"; 
 }
 if (tusf >= 68) {
 fdirenc = "< 10k"; 
 }
 if (tusf >= 248) {
 fdirenc = "< 1k"; 
 }
 if (tusf >= 338) {
 fdirenc = "< 100R"; 
 }
 if (tusf >= 350) {
 fdirenc = "< 10R"; 
 }

 lcd.clear();
 
 lcd.setCursor(0,0);
 lcd.print("Durum Raporu..");
 lcd.setCursor(0,1);
 
 if (tusf >= 3 && tusr >= 3) {
 lcd.print(adim + " <> " + fdirenc);
}

  if (tusf >= 3 && tusr < 3) {
 lcd.print(adim + " > DIYOT ");
}

  if (tusf < 3 && tusr >= 3) {
 lcd.print(adim + " < DIYOT ");
}

  digitalWrite(alarm, HIGH); 
  delay(10);
  digitalWrite(alarm, LOW); 
    
  delay(400); 
  
 }


 void menu() {

 if (dmenu == 0) {
 lcd.clear();
 lcd.setCursor(1,0);
 lcd.print("Test Modu Sec");
 lcd.setCursor(0,1);
 lcd.print("<   TAM TEST   >");
 dmenu = 1;
 }

 if (digitalRead(sec) == HIGH) {
 dmenu++;
 digitalWrite(alarm, HIGH); 
 delay(10);
 digitalWrite(alarm, LOW);
 delay(300);
 }

 if (dmenu == 2) {
 lcd.clear();
 lcd.setCursor(1,0);
 lcd.print("Test Modu Sec");
 lcd.setCursor(0,1);
 lcd.print("<   DIYOTSUZ   >");
 dmenu = 3;
 }

 if (dmenu == 4) {
 dmenu = 0;  
 }

 }

